# 帳票設計書 9-Count Report

## 概要

本ドキュメントは、OpenSearchの `_cat/count` APIが出力するCount Reportの帳票設計書である。インデックスまたはクラスタ全体のドキュメント数をテキストテーブル形式で出力するCat APIエンドポイントの仕様を定義する。

### 本帳票の処理概要

Count Reportは、指定されたインデックスまたはクラスタ全体のドキュメント数を1行のテキストテーブルとして出力するシンプルな帳票である。内部的にはSearch APIを使用してドキュメント数を取得する。

**業務上の目的・背景**：インデックス内のドキュメント数を簡便に確認するために使用する。Indices Statsよりも軽量で、正確なドキュメント数（EQUAL_TO精度）を取得できる。

**帳票の利用シーン**：データ投入結果の確認、インデックス内のドキュメント数モニタリング、データパイプラインの検証、簡易的なデータ量確認に利用される。

**主要な出力内容**：
1. タイムスタンプ（エポック秒、時刻文字列）
2. ドキュメント数

**帳票の出力タイミング**：ユーザーが `GET /_cat/count` または `GET /_cat/count/{index}` エンドポイントにHTTPリクエストを送信した時点で出力される。

**帳票の利用者**：アプリケーション開発者、データエンジニア、クラスタ管理者。

## 帳票種別

一覧表（テキストテーブル形式のドキュメント数レポート）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | Cat カウント | `GET /_cat/count` | HTTP GETリクエスト |
| - | Cat カウント（指定） | `GET /_cat/count/{index}` | HTTP GETリクエスト |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（text/plain）/ JSON（application/json） |
| 用紙サイズ | N/A |
| 向き | N/A |
| ファイル名 | N/A |
| 出力方法 | HTTPレスポンス |
| 文字コード | UTF-8 |

## 帳票レイアウト

### レイアウト概要

タイムスタンプ付きの1行テーブルとしてドキュメント数を出力する。

```
┌────────────────────────────────┐
│ epoch      timestamp   count   │
├────────────────────────────────┤
│ 1706...    10:30:00    12345   │
└────────────────────────────────┘
```

### ヘッダー部（タイムスタンプヘッダー）

`startHeadersWithTimestamp()` メソッドにより自動付与。

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | epoch | UNIXエポック秒 | システム時刻 | 数値 |
| 2 | timestamp | 時刻文字列 | システム時刻 | HH:mm:ss |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | count | ドキュメント数 | SearchResponse.getHits().getTotalHits().value() | 数値 |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| index | インデックス名パターン（カンマ区切り） | No |
| クエリ | URLパラメータまたはリクエストボディでクエリ指定可能 | No |

### ソート順

ソート対象なし（常に1行の出力）。

### 改ページ条件

改ページは発生しない。

## データベース参照仕様

### 参照テーブル一覧

| データソース | 用途 | 取得方法 |
|-----------|------|---------|
| SearchResponse | ドキュメント数（TotalHits） | SearchRequest（size=0, trackTotalHits=true） |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| count | SearchResponse.getHits().getTotalHits().value() | なし | TotalHits.Relation.EQUAL_TO が保証される |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[GET /_cat/count リクエスト受信] --> B[doCatRequest]
    B --> C[SearchRequest 生成 - size=0, trackTotalHits=true]
    C --> D{クエリ指定あり?}
    D -->|Body| E[リクエストボディからクエリ解析]
    D -->|URLパラメータ| F[URLパラメータからクエリ構築]
    D -->|なし| G[全件カウント]
    E --> H[client.search 実行]
    F --> H
    G --> H
    H --> I[buildTable でテーブル構築]
    I --> J[RestTable.buildResponse]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| クエリ解析エラー | リクエストボディのクエリが不正 | "Couldn't parse query" | クエリ構文の修正 |
| インデックス存在しない | 指定インデックスが存在しない | インデックス不存在エラー | インデックス名の確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 常に1行 |
| 目標出力時間 | ミリ秒～数秒（Search APIの実行時間に依存） |
| 同時出力数上限 | 制限なし |

## セキュリティ考慮事項

- Search APIを使用するため、インデックスの読み取り権限が必要。
- クエリ指定によるデータ漏洩リスクはSearch API自体のセキュリティ設計に準拠。

## 備考

- 他のCat APIと異なり、内部的にSearch APIを使用する。size=0, trackTotalHits=true で件数のみを取得する。
- TotalHits.Relation.EQUAL_TO がアサーションで保証されており、概算値ではなく正確な値を返す。
- クエリ指定はURLパラメータ（RestActions.urlParamsToQueryBuilder）またはリクエストボディ（RestActions.getQueryContent）で可能。

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | RestCountAction.java | `server/src/main/java/org/opensearch/rest/action/cat/RestCountAction.java` | 行109-115: getTableWithHeader() でタイムスタンプ付き1カラム定義 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestCountAction.java | `server/src/main/java/org/opensearch/rest/action/cat/RestCountAction.java` | 行80-106: doCatRequest() で SearchRequest を生成 |

**主要処理フロー**:
1. **行81**: インデックス名パラメータ取得
2. **行82-84**: SearchRequest 生成（size=0, trackTotalHits=true）
3. **行86-98**: クエリ解析（ボディまたはURLパラメータ）
4. **行99-105**: client.search() 実行、buildTable() 呼び出し
5. **行102**: TotalHits.Relation.EQUAL_TO のアサーション

#### Step 3: テーブル構築ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | RestCountAction.java | `server/src/main/java/org/opensearch/rest/action/cat/RestCountAction.java` | 行117-124: buildTable() で1行のテーブル構築 |

### プログラム呼び出し階層図

```
AbstractCatAction.prepareRequest()
    |
    +-- RestCountAction.doCatRequest() [行80]
           |
           +-- SearchRequest 生成 [行82]
           +-- SearchSourceBuilder(size=0, trackTotalHits=true) [行83]
           +-- クエリ解析 [行86-98]
           |      |
           |      +-- RestActions.urlParamsToQueryBuilder() [行88]
           |      +-- RestActions.getQueryContent() [行93]
           |
           +-- client.search() [行99]
                  |
                  +-- buildTable() [行117]
                  +-- RestTable.buildResponse() [行103]
```

### データフロー図

```
[入力]                      [処理]                        [出力]

GET /_cat/count     --->  SearchRequest             --->  テキストテーブル
GET /_cat/count/{idx}     (size=0, trackTotalHits)        (1行: count)
                               |
                               v
                        SearchResponse
                        (TotalHits.value)
                               |
                               v
                        buildTable() → Table
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestCountAction.java | `server/src/main/java/org/opensearch/rest/action/cat/RestCountAction.java` | ソース | Count Report メイン処理（Cat API版） |
| RestCountAction.java (search) | `server/src/main/java/org/opensearch/rest/action/search/RestCountAction.java` | ソース | Count API（別のエンドポイント） |
| RestActions.java | `server/src/main/java/org/opensearch/rest/action/RestActions.java` | ソース | クエリ解析ユーティリティ |
| AbstractCatAction.java | `server/src/main/java/org/opensearch/rest/action/cat/AbstractCatAction.java` | ソース | Cat API共通基底クラス |
